/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ku extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "ereb\u00ee";
        final String metaValue_hy = "ermen\u00ee";
        final String metaValue_bn = "bengal\u00ee";
        final String metaValue_ka = "gurc\u00ee";
        final String metaValue_el = "y\u00fbnan\u00ee";
        final String metaValue_he = "\u00eebran\u00ee";
        final String metaValue_ja = "japon\u00ee";
        final String metaValue_km = "xim\u00ear\u00ee";
        final String metaValue_kn = "kannaday\u00ee";
        final String metaValue_ko = "korey\u00ee";
        final String metaValue_la = "lat\u00een\u00ee";
        final String metaValue_mn = "moxol\u00ee";
        final String metaValue_ta = "tam\u00eel\u00ee";
        final String metaValue_th = "tay\u00ee";
        final String metaValue_bo = "t\u00eebet\u00ee";
        final Object[][] data = new Object[][] {
            { "001", "dinya" },
            { "002", "Afr\u00eeka" },
            { "003", "Amer\u00eekaya Bakur" },
            { "005", "Amer\u00eekaya Ba\u015f\u00fbr" },
            { "009", "Okyan\u00fbsya" },
            { "011", "Rojavay\u00ea Afr\u00eekay\u00ea" },
            { "013", "Amer\u00eekaya Nav\u00een" },
            { "014", "Rojhilat\u00ea Afr\u00eekay\u00ea" },
            { "015", "Bakur\u00ea Afr\u00eekay\u00ea" },
            { "017", "Afr\u00eekaya Nav\u00een" },
            { "018", "Ba\u015f\u00fbr\u00ea Afr\u00eekay\u00ea" },
            { "019", "Amer\u00eeka" },
            { "021", "Bakur\u00ea Amer\u00eekay\u00ea" },
            { "029", "Karay\u00eeb" },
            { "030", "Rojhilat\u00ea Asyay\u00ea" },
            { "034", "Ba\u015f\u00fbr\u00ea Asyay\u00ea" },
            { "035", "Ba\u015f\u00fbrrojhilat\u00ea Asyay\u00ea" },
            { "039", "Ba\u015f\u00fbr\u00ea Ewropay\u00ea" },
            { "053", "Awistralasya" },
            { "054", "Melanezya" },
            { "057", "Her\u00eama M\u00eekronezyay\u00ea" },
            { "061", "Pol\u00eenezya" },
            { "142", "Asya" },
            { "143", "Asyaya Nav\u00een" },
            { "145", "Rojavay\u00ea Asyay\u00ea" },
            { "150", "Ewropa" },
            { "151", "Rojhilat\u00ea Ewropay\u00ea" },
            { "154", "Bakur\u00ea Ewropay\u00ea" },
            { "155", "Rojavay\u00ea Ewropay\u00ea" },
            { "202", "Afr\u00eekaya J\u00eara Sahray\u00ea" },
            { "419", "Amer\u00eekaya Lat\u00een" },
            { "AC", "Girava Ascension\u00ea" },
            { "AD", "Andorra" },
            { "AE", "M\u00eergeh\u00ean Ereb\u00ee y\u00ean Yekb\u00fby\u00ee" },
            { "AF", "Efxanistan" },
            { "AG", "Ant\u00eegua \u00fb Berb\u00fbda" },
            { "AI", "Angu\u00eela" },
            { "AL", "Albanya" },
            { "AM", "Ermenistan" },
            { "AO", "Angola" },
            { "AQ", "Antarkt\u00eeka" },
            { "AR", "Arjant\u00een" },
            { "AS", "Samoaya Amer\u00eekan\u00ee" },
            { "AT", "Awistirya" },
            { "AU", "Awistralya" },
            { "AW", "Ar\u00fbba" },
            { "AX", "Girav\u00ean Aland\u00ea" },
            { "AZ", "Azerbeycan" },
            { "BA", "Bosna \u00fb Hersek" },
            { "BB", "Barbados" },
            { "BD", "Benglade\u015f" },
            { "BE", "Bel\u00e7\u00eeka" },
            { "BF", "Burk\u00eena Faso" },
            { "BG", "Bulgaristan" },
            { "BH", "Behreyn" },
            { "BI", "B\u00fbr\u00fbnd\u00ee" },
            { "BJ", "B\u00ean\u00een" },
            { "BL", "Saint Barthelemy" },
            { "BM", "Berm\u00fbda" },
            { "BN", "Br\u00fbney" },
            { "BO", "Bol\u00eevya" },
            { "BQ", "Holendaya Karay\u00eeb\u00ea" },
            { "BR", "Brez\u00eelya" },
            { "BS", "Bahama" },
            { "BT", "B\u00fbtan" },
            { "BV", "Girava Bouvet\u00ea" },
            { "BW", "Botswana" },
            { "BY", "Belar\u00fbs" },
            { "BZ", "Bel\u00eeze" },
            { "CA", "Kanada" },
            { "CC", "Girav\u00ean Kokos\u00ea (Keeling)" },
            { "CD", "Kongo - K\u00een\u015fasa" },
            { "CF", "Komara Afr\u00eekaya Nav\u00een" },
            { "CG", "Kongo - Brazzaville" },
            { "CH", "Sw\u00eesre" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Girav\u00ean Cook\u00ea" },
            { "CL", "\u015e\u00eele" },
            { "CM", "Kamer\u00fbn" },
            { "CN", "\u00c7\u00een" },
            { "CO", "Kolomb\u00eeya" },
            { "CP", "Girava Clipperton\u00ea" },
            { "CQ", "Sark" },
            { "CR", "Kosta R\u00eeka" },
            { "CU", "Kuba" },
            { "CV", "Kap Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Girava Christmas\u00ea" },
            { "CY", "Qibris" },
            { "CZ", "\u00c7ekya" },
            { "DE", "Almanya" },
            { "DG", "Diego Garcia" },
            { "DJ", "C\u00eeb\u00fbt\u00ee" },
            { "DK", "Dan\u00eemarka" },
            { "DM", "Dom\u00een\u00eeka" },
            { "DO", "Komara Dom\u00een\u00eek\u00ea" },
            { "DZ", "Cezay\u00eer" },
            { "EA", "Ceuta \u00fb Mel\u00eela" },
            { "EC", "Ekwador" },
            { "EE", "Estonya" },
            { "EG", "Misir" },
            { "EH", "Sahraya Rojava" },
            { "ER", "Er\u00eetre" },
            { "ES", "Spanya" },
            { "ET", "Et\u00eeyopya" },
            { "EU", "Yek\u00eet\u00eeya Ewropay\u00ea" },
            { "EZ", "Her\u00eama Ewroy\u00ea" },
            { "FI", "F\u00eenlenda" },
            { "FJ", "F\u00eej\u00ee" },
            { "FK", "Girav\u00ean Falkland\u00ea" },
            { "FM", "M\u00eekronezya" },
            { "FO", "Girav\u00ean Faroey\u00ea" },
            { "FR", "Fransa" },
            { "GA", "Gabon" },
            { "GB", "Qiral\u00eeyeta Yekb\u00fby\u00ee" },
            { "GD", "Grenada" },
            { "GE", "Gurcistan" },
            { "GF", "Guyanaya Frans\u00ee" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "GI", "Cebel\u00eetariq" },
            { "GL", "Gr\u00eenlanda" },
            { "GM", "Gamb\u00eeya" },
            { "GN", "G\u00eene" },
            { "GP", "Guadeloupe" },
            { "GQ", "G\u00eeneya Ekwador\u00ea" },
            { "GR", "Y\u00fbnanistan" },
            { "GS", "Girav\u00ean Georg\u00eeyaya Ba\u015f\u00fbr \u00fb Sandwicha Ba\u015f\u00fbr" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "G\u00eene-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hong Konga H\u00eeT ya \u00c7\u00een\u00ea" },
            { "HM", "Girav\u00ean Heard \u00fb MacDonald\u00ea" },
            { "HN", "Hond\u00fbras" },
            { "HR", "Xirwatistan" },
            { "HT", "Ha\u00eet\u00ee" },
            { "HU", "Macaristan" },
            { "IC", "Girav\u00ean Kanaryay\u00ea" },
            { "ID", "Endonezya" },
            { "IE", "\u00cerlanda" },
            { "IL", "\u00cesra\u00eel" },
            { "IM", "Girava Man\u00ea" },
            { "IN", "Hindistan" },
            { "IO", "Her\u00eama Okyan\u00fbsa Hind\u00ee ya Br\u00eetanyay\u00ea" },
            { "IQ", "\u00ceraq" },
            { "IR", "\u00ceran" },
            { "IS", "\u00ceslanda" },
            { "IT", "\u00cetalya" },
            { "JE", "Jersey" },
            { "JM", "Jama\u00eeka" },
            { "JO", "Urdun" },
            { "JP", "Japonya" },
            { "KE", "Kenya" },
            { "KG", "Qirgizistan" },
            { "KH", "Kambo\u00e7ya" },
            { "KI", "Kir\u00eebat\u00ee" },
            { "KM", "Komor" },
            { "KN", "Saint Kitts \u00fb Nev\u00ees" },
            { "KP", "Koreya Bakur" },
            { "KR", "Koreya Ba\u015f\u00fbr" },
            { "KW", "Kuweyt" },
            { "KY", "Girav\u00ean Kayman\u00ea" },
            { "KZ", "Qazaxistan" },
            { "LA", "Laos" },
            { "LB", "Libnan" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sr\u00ee Lanka" },
            { "LR", "L\u00eeberya" },
            { "LS", "Lesoto" },
            { "LT", "L\u00eetvanya" },
            { "LU", "Luksemb\u00fbrg" },
            { "LV", "Letonya" },
            { "LY", "L\u00eebya" },
            { "MA", "Fas" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Girav\u00ean Mar\u015fal\u00ea" },
            { "MK", "Makendonyaya Bakur" },
            { "ML", "Mal\u00ee" },
            { "MM", "Myanmar (B\u00fbrma)" },
            { "MN", "Moxolistan" },
            { "MO", "Makaoya H\u00eet ya \u00c7\u00een\u00ea" },
            { "MP", "Girav\u00ean Bakur\u00ea Marianan" },
            { "MQ", "Mart\u00een\u00eek" },
            { "MR", "Mor\u00eetanya" },
            { "MS", "Montserat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Mald\u00eeva" },
            { "MW", "Malaw\u00ee" },
            { "MX", "Meks\u00eeka" },
            { "MY", "Malezya" },
            { "MZ", "Mozamb\u00eek" },
            { "NA", "Nam\u00eebya" },
            { "NC", "Kaledonyaya N\u00fb" },
            { "NE", "N\u00eejer" },
            { "NF", "Girava Norfolk\u00ea" },
            { "NG", "N\u00eejerya" },
            { "NI", "N\u00eekaragua" },
            { "NL", "Holanda" },
            { "NO", "Norw\u00eac" },
            { "NP", "Nepal" },
            { "NR", "Na\u00fbr\u00fb" },
            { "NU", "Ni\u00fbe" },
            { "NZ", "Zelandaya N\u00fb" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Per\u00fb" },
            { "PF", "Pol\u00eenezyaya Fransiz\u00ee" },
            { "PG", "Papua G\u00eeneya N\u00fb" },
            { "PH", "F\u00eel\u00eep\u00een" },
            { "PK", "Pakistan" },
            { "PL", "Polonya" },
            { "PM", "Saint-Pierre \u00fb Miquelon" },
            { "PN", "Girav\u00ean Pitcairn\u00ea" },
            { "PR", "Porto R\u00eeko" },
            { "PS", "Her\u00eam\u00ean Fil\u00eest\u00een\u00ee" },
            { "PT", "Port\u00fbgal" },
            { "PW", "Palau" },
            { "PY", "Parag\u00fbay" },
            { "QA", "Qeter" },
            { "QO", "Okyan\u00fbsyaya D\u00fbr" },
            { "RE", "R\u00e9union" },
            { "RO", "Romanya" },
            { "RS", "Sirbistan" },
            { "RU", "R\u00fbsya" },
            { "RW", "Rwanda" },
            { "SA", "Erebistana Si\u00fbd\u00ee" },
            { "SB", "Girav\u00ean Solomon\u00ea" },
            { "SC", "Sey\u015fel" },
            { "SD", "S\u00fbdan" },
            { "SE", "Sw\u00ead" },
            { "SG", "S\u00eengap\u00fbr" },
            { "SH", "Saint Helena" },
            { "SI", "Slovenya" },
            { "SJ", "Svalbard \u00fb Jan Mayen" },
            { "SK", "Slovakya" },
            { "SL", "Sierra Leone" },
            { "SM", "San Mar\u00eeno" },
            { "SN", "Senegal" },
            { "SO", "Somalya" },
            { "SR", "Sur\u00eenam" },
            { "SS", "S\u00fbdana Ba\u015f\u00fbr" },
            { "ST", "Sao Tome \u00fb Pr\u00eens\u00eepe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Marteen" },
            { "SY", "S\u00fbr\u00eeye" },
            { "SZ", "Eswat\u00een\u00ee" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Girav\u00ean Turks \u00fb Ka\u00eekos\u00ea" },
            { "TD", "\u00c7ad" },
            { "TF", "Her\u00eam\u00ean Ba\u015f\u00fbr \u00ean Fransay\u00ea" },
            { "TG", "Togo" },
            { "TH", "Tayland" },
            { "TJ", "Tac\u00eekistan" },
            { "TK", "Tokelau" },
            { "TL", "T\u00eemor-Leste" },
            { "TM", "Tirkmenistan" },
            { "TN", "T\u00fbnis" },
            { "TO", "Tonga" },
            { "TR", "Tirk\u00eeye" },
            { "TT", "Tr\u00een\u00eedad \u00fb Tobago" },
            { "TV", "T\u00fbval\u00fb" },
            { "TW", "Taywan" },
            { "TZ", "Tanzanya" },
            { "UA", "\u00dbkrayna" },
            { "UG", "\u00dbganda" },
            { "UM", "Girav\u00ean Bi\u00e7\u00fbk \u00ean Dervey\u00ee DYAy\u00ea" },
            { "UN", "Milet\u00ean Yekb\u00fby\u00ee" },
            { "US", "Dewlet\u00ean Yekb\u00fby\u00ee y\u00ean Amer\u00eekay\u00ea" },
            { "UY", "\u00dbr\u00fbguay" },
            { "UZ", "Ozbekistan" },
            { "VA", "Vat\u00eekan" },
            { "VC", "Saint Vincent \u00fb Girav\u00ean Grenad\u00een\u00ea" },
            { "VE", "Venezuela" },
            { "VG", "Girav\u00ean V\u00eerj\u00een\u00ea y\u00ean Br\u00eetanyay\u00ea" },
            { "VI", "Girav\u00ean V\u00eerj\u00een\u00ea y\u00ean Amer\u00eekay\u00ea" },
            { "VN", "V\u00eeetnam" },
            { "VU", "Van\u00fbat\u00fb" },
            { "WF", "Wallis \u00fb Futuna" },
            { "WS", "Samoa" },
            { "XA", "Aksan\u00ean Psodoy\u00ea" },
            { "XB", "Psodo Bid\u00ee" },
            { "XK", "Kosova" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "Afr\u00eekaya Ba\u015f\u00fbr" },
            { "ZM", "Zamb\u00eeya" },
            { "ZW", "Z\u00eembabwe" },
            { "ZZ", "Her\u00eama Nenas" },
            { "aa", "afar\u00ee" },
            { "ab", "abxaz\u00ee" },
            { "af", "afr\u00eekans\u00ee" },
            { "ak", "akan\u00ee" },
            { "am", "amhar\u00ee" },
            { "an", "aragon\u00ee" },
            { "ar", metaValue_ar },
            { "as", "asam\u00ee" },
            { "av", "avar\u00ee" },
            { "ay", "aymaray\u00ee" },
            { "az", "azer\u00ee" },
            { "ba", "ba\u015fk\u00eer\u00ee" },
            { "be", "belar\u00fbs\u00ee" },
            { "bg", "bulgar\u00ee" },
            { "bi", "b\u00eeslamay\u00ee" },
            { "bm", "bambaray\u00ee" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "breton\u00ee" },
            { "bs", "bosn\u00ee" },
            { "ca", "katalan\u00ee" },
            { "ce", "\u00e7e\u00e7en\u00ee" },
            { "ch", "\u00e7amoroy\u00ee" },
            { "co", "kors\u00eekay\u00ee" },
            { "cs", "\u00e7ek\u00ee" },
            { "cu", "slav\u00eeya ken\u00eesey\u00ee" },
            { "cv", "\u00e7uva\u015f\u00ee" },
            { "cy", "weyls\u00ee" },
            { "da", "danmark\u00ee" },
            { "de", "alman\u00ee" },
            { "dv", "diveh\u00ee" },
            { "dz", "conxay\u00ee" },
            { "ee", "ewey\u00ee" },
            { "el", metaValue_el },
            { "en", "\u00eengil\u00eez\u00ee" },
            { "eo", "esperantoy\u00ee" },
            { "es", "span\u00ee" },
            { "et", "eston\u00ee" },
            { "eu", "bask\u00ee" },
            { "fa", "faris\u00ee" },
            { "ff", "fulah\u00ee" },
            { "fi", "f\u00een\u00ee" },
            { "fj", "f\u00eej\u00ee" },
            { "fo", "fer\u00ee" },
            { "fr", "fransiz\u00ee" },
            { "fy", "fr\u00ees\u00ee" },
            { "ga", "\u00eerlend\u00ee" },
            { "gd", "gael\u00eeka skot\u00ee" },
            { "gl", "gal\u00ees\u00ee" },
            { "gn", "guwaran\u00ee" },
            { "gu", "gujarat\u00ee" },
            { "gv", "manks\u00ee" },
            { "ha", "hawsay\u00ee" },
            { "he", metaValue_he },
            { "hi", "hind\u00ee" },
            { "hr", "xirwat\u00ee" },
            { "ht", "ha\u00eet\u00ee" },
            { "hu", "mecar\u00ee" },
            { "hy", metaValue_hy },
            { "hz", "hereroy\u00ee" },
            { "ia", "\u00eenterl\u00eengua" },
            { "id", "endonezyay\u00ee" },
            { "ie", "\u00eenterl\u00eengue" },
            { "ig", "\u00eegboy\u00ee" },
            { "ii", "y\u00eey\u00eeya si\u00e7uway\u00ee" },
            { "io", "\u00eedoy\u00ee" },
            { "is", "\u00eezlend\u00ee" },
            { "it", "\u00eetal\u00ee" },
            { "iu", "\u00eenu\u00eet\u00ee" },
            { "ja", metaValue_ja },
            { "jv", "javay\u00ee" },
            { "ka", metaValue_ka },
            { "ki", "k\u00eek\u00fby\u00fby\u00ee" },
            { "kj", "kwanyamay\u00ee" },
            { "kk", "qazax\u00ee" },
            { "kl", "kalal\u00ees\u00fbt\u00ee" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanur\u00eey\u00ee" },
            { "ks", "ke\u015fm\u00eer\u00ee" },
            { "ku", "kurd\u00ee (kurmanc\u00ee)" },
            { "kv", "kom\u00ee" },
            { "kw", "korn\u00ee" },
            { "ky", "kirgiz\u00ee" },
            { "la", metaValue_la },
            { "lb", "luksemb\u00fbrg\u00ee" },
            { "lg", "luganday\u00ee" },
            { "li", "l\u00eemb\u00fbrg\u00ee" },
            { "ln", "lingalay\u00ee" },
            { "lo", "laws\u00ee" },
            { "lt", "l\u00eetwan\u00ee" },
            { "lu", "luba-katangay\u00ee" },
            { "lv", "latv\u00eeyay\u00ee" },
            { "mg", "malagas\u00ee" },
            { "mh", "mar\u015fal\u00ee" },
            { "mi", "maor\u00ee" },
            { "mk", "makedon\u00ee" },
            { "ml", "malayalam\u00ee" },
            { "mn", metaValue_mn },
            { "mr", "marat\u00ee" },
            { "ms", "malez\u00ee" },
            { "mt", "maltay\u00ee" },
            { "my", "burmay\u00ee" },
            { "na", "nawr\u00fby\u00ee" },
            { "nb", "norwec\u00ee (bokm\u00e5l)" },
            { "nd", "ndebel\u00eeya bakur\u00ee" },
            { "ne", "nepal\u00ee" },
            { "ng", "ndongay\u00ee" },
            { "nl", "holend\u00ee" },
            { "nn", "norwec\u00ee (nynorsk)" },
            { "no", "norwec\u00ee" },
            { "nr", "ndebel\u00eeya ba\u015f\u00fbr\u00ee" },
            { "nv", "navajoy\u00ee" },
            { "ny", "\u00e7\u00ee\u00e7eway\u00ee" },
            { "oc", "oks\u00eetan\u00ee" },
            { "om", "oromoy\u00ee" },
            { "or", "oriyay\u00ee" },
            { "os", "oset\u00ee" },
            { "pa", "puncab\u00ee" },
            { "pl", "polon\u00ee" },
            { "ps", "pe\u015ft\u00fby\u00ee" },
            { "pt", "portugal\u00ee" },
            { "qu", "ke\u00e7way\u00ee" },
            { "rm", "romanc\u00ee" },
            { "rn", "rund\u00ee" },
            { "ro", "roman\u00ee" },
            { "ru", "r\u00fbs\u00ee" },
            { "rw", "k\u00eenyariwanday\u00ee" },
            { "sa", "sanskr\u00eet\u00ee" },
            { "sc", "sard\u00een\u00ee" },
            { "sd", "sindh\u00ee" },
            { "se", "sam\u00eeya bakur" },
            { "sg", "sangoy\u00ee" },
            { "si", "k\u00eengal\u00ee" },
            { "sk", "slovak\u00ee" },
            { "sl", "sloven\u00ee" },
            { "sm", "samoay\u00ee" },
            { "sn", "\u015fonay\u00ee" },
            { "so", "somal\u00ee" },
            { "sq", "arnawid\u00ee" },
            { "sr", "sirb\u00ee" },
            { "ss", "swaz\u00ee" },
            { "st", "sotoy\u00eeya ba\u015f\u00fbr" },
            { "su", "sundan\u00ee" },
            { "sv", "sw\u00ead\u00ee" },
            { "sw", "swah\u00eel\u00ee" },
            { "ta", metaValue_ta },
            { "te", "tel\u00fbg\u00fby\u00ee" },
            { "tg", "tacik\u00ee" },
            { "th", metaValue_th },
            { "ti", "tigr\u00een\u00ee" },
            { "tk", "tirkmen\u00ee" },
            { "tn", "tswanay\u00ee" },
            { "to", "tong\u00ee" },
            { "tr", "tirk\u00ee" },
            { "ts", "tsongay\u00ee" },
            { "tt", "teter\u00ee" },
            { "ty", "tah\u00eet\u00ee" },
            { "ug", "oygur\u00ee" },
            { "uk", "ukrayn\u00ee" },
            { "ur", "urd\u00fby\u00ee" },
            { "uz", "ozbek\u00ee" },
            { "vi", "v\u00eeetnam\u00ee" },
            { "vo", "volap\u00fbk\u00ee" },
            { "wa", "walon\u00ee" },
            { "wo", "wolof\u00ee" },
            { "xh", "xosay\u00ee" },
            { "yi", "yid\u00ee\u015f\u00ee" },
            { "yo", "yorubay\u00ee" },
            { "za", "zhuang\u00ee" },
            { "zh", "\u00e7\u00een\u00ee" },
            { "zu", "zuluy\u00ee" },
            { "ace", "a\u00e7eh\u00ee" },
            { "ada", "adangmey\u00ee" },
            { "ady", "ad\u00eegey\u00ee" },
            { "agq", "aghem\u00ee" },
            { "ain", "aynuy\u00ee" },
            { "ale", "al\u00eaw\u00eet\u00ee" },
            { "alt", "altay\u00eeya ba\u015f\u00fbr\u00ee" },
            { "ann", "obolo" },
            { "anp", "ang\u00eekay\u00ee" },
            { "apc", "ereb\u00eeya bakur\u00ea \u015fam\u00ea" },
            { "arn", "mapu\u00e7\u00ee" },
            { "arp", "arapahoy\u00ee" },
            { "ars", "ereb\u00eeya necd\u00ee" },
            { "asa", "as\u00fby\u00ee" },
            { "ast", "ast\u00fbr\u00ee" },
            { "atj", "at\u00eekamek\u00ee" },
            { "awa", "awadh\u00ee" },
            { "bal", "bel\u00fbc\u00ee" },
            { "ban", "bal\u00een\u00ee" },
            { "bas", "basay\u00ee" },
            { "bem", "bembay\u00ee" },
            { "bew", "betaw\u00ee" },
            { "bez", "benay\u00ee" },
            { "bgc", "haryanv\u00eey\u00ee" },
            { "bgn", "beluc\u00eeya rojavay\u00ee" },
            { "bho", "bojp\u00fbr\u00ee" },
            { "bin", "b\u00een\u00eey\u00ee" },
            { "bla", "blakfot\u00ee" },
            { "blo", "bloy\u00ee" },
            { "blt", "tay dam" },
            { "brx", "bodoy\u00ee" },
            { "bss", "akoosey\u00ee" },
            { "bug", "bug\u00ee" },
            { "byn", "bl\u00een\u00ee" },
            { "cad", "kadoy\u00ee" },
            { "cay", "kayugay\u00ee" },
            { "cch", "atsam\u00ee" },
            { "ccp", "\u00e7akmay\u00ee" },
            { "ceb", "sebwanoy\u00ee" },
            { "cgg", "k\u00eegay\u00ee" },
            { "chk", "\u00e7\u00fbk\u00ee" },
            { "chm", "mar\u00ee" },
            { "cho", "\u00e7oktav\u00ee" },
            { "chp", "\u00e7\u00eepevyay\u00ee" },
            { "chr", "\u00e7erok\u00ee" },
            { "chy", "\u00e7eyen\u00ee" },
            { "cic", "\u00e7\u00eekasaw\u00ee" },
            { "ckb", "kurd\u00ee (soran\u00ee)" },
            { "clc", "\u00e7ilkot\u00een\u00ee" },
            { "crg", "m\u00ee\u00e7\u00eef\u00ee" },
            { "crj", "kr\u00eeya rojhilat ya ba\u015f\u00fbr\u00ee" },
            { "crk", "kriya bejay\u00ee" },
            { "crl", "kr\u00eeya rojhilat ya bakur\u00ee" },
            { "crm", "kr\u00eeya m\u00fbs\u00ee" },
            { "crr", "ziman\u00ea karolina algonquian\u00ee" },
            { "csw", "kr\u00eeya swamp\u00ee" },
            { "dak", "dakotay\u00ee" },
            { "dar", "darg\u00een\u00ee" },
            { "dav", "tay\u00eetay\u00ee" },
            { "dgr", "dogr\u00eeb\u00ee" },
            { "dje", "zarma" },
            { "doi", "dogr\u00eey\u00ee" },
            { "dsb", "sorb\u00eeya j\u00ear\u00een" },
            { "dua", "diwalay\u00ee" },
            { "dyo", "jola-fonyi" },
            { "dzg", "dazagay\u00ee" },
            { "ebu", "embuy\u00ee" },
            { "efi", "ef\u00eek\u00ee" },
            { "eka", "ekajuk\u00ee" },
            { "ewo", "ewondoy\u00ee" },
            { "fil", "f\u00eel\u00eep\u00eenoy\u00ee" },
            { "fon", "fon\u00ee" },
            { "frc", "fransiz\u00eeya kaj\u00fbn\u00ea" },
            { "frr", "fr\u00ees\u00eeya bakur" },
            { "fur", "fr\u00eeyol\u00ee" },
            { "gaa", "gay\u00ee" },
            { "gez", "geez" },
            { "gil", "k\u00eer\u00eebat\u00ee" },
            { "gor", "gorontaloy\u00ee" },
            { "gsw", "elman\u00ee\u015f\u00ee" },
            { "guz", "gus\u00ee\u00ee" },
            { "gwi", "gwich\u02bcin" },
            { "hai", "hayday\u00ee" },
            { "haw", "haway\u00ee" },
            { "hax", "ha\u00eedaya ba\u015f\u00fbr\u00ee" },
            { "hil", "h\u00eel\u00eegaynon\u00ee" },
            { "hmn", "hmong\u00ee" },
            { "hnj", "hmong\u00eeya njuay\u00ee" },
            { "hsb", "sorb\u00eeya jor\u00een" },
            { "hup", "hupay\u00ee" },
            { "hur", "halkomelem\u00ee" },
            { "iba", "iban" },
            { "ibb", "\u00eeb\u00eeb\u00eeoy\u00ee" },
            { "ikt", "inuvialuktun" },
            { "ilo", "\u00eelokanoy\u00ee" },
            { "inh", "\u00eeng\u00fb\u015f\u00ee" },
            { "jbo", "lojban\u00ee" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "kaa", "kara-kalpak\u00ee" },
            { "kab", "kab\u00eel\u00ee" },
            { "kac", "cingphoy\u00ee" },
            { "kaj", "jju" },
            { "kam", "kambay\u00ee" },
            { "kbd", "kabard\u00ee" },
            { "kcg", "tyap" },
            { "kde", "makondey\u00ee" },
            { "kea", "kapverd\u00ee" },
            { "ken", "kenyang\u00ee" },
            { "kfo", "koro" },
            { "kgp", "kayingang\u00ee" },
            { "kha", "khasi" },
            { "khq", "koyra chiini" },
            { "kkj", "kako" },
            { "kln", "kalenc\u00een\u00ee" },
            { "kmb", "k\u00eembunduy\u00ee" },
            { "kok", "konkan\u00ee" },
            { "kpe", "kpelley\u00ee" },
            { "krc", "kara\u00e7ay-balkar\u00ee" },
            { "krl", "karel\u00ee" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafyay\u00ee" },
            { "ksh", "r\u00eepwar\u00ee" },
            { "kum", "kumik\u00ee" },
            { "kwk", "kwak\u2019walay\u00ee" },
            { "kxv", "kuv\u00ee" },
            { "lad", "lad\u00eenoy\u00ee" },
            { "lag", "lang\u00ee" },
            { "lez", "lezg\u00een\u00ee" },
            { "lij", "l\u00eeg\u00fbr\u00ee" },
            { "lil", "lillooet" },
            { "lkt", "lakotay\u00ee" },
            { "lmo", "lombard\u00ee" },
            { "lou", "kreyol\u00eeya louisianay\u00ea" },
            { "loz", "loz\u00ee" },
            { "lrc", "lur\u00eeya bakur" },
            { "lsm", "saamia" },
            { "ltg", "latgal\u00ee" },
            { "lua", "luba-kasay\u00ee" },
            { "lun", "lunda" },
            { "luo", "luoy\u00ee" },
            { "lus", "mizoy\u00ee" },
            { "luy", "luhyay\u00ee" },
            { "mad", "maduray\u00ee" },
            { "mag", "magah\u00ee" },
            { "mai", "maithili" },
            { "mak", "makasar\u00ee" },
            { "mas", "masay\u00ee" },
            { "mdf", "mok\u015fay\u00ee" },
            { "men", "mende" },
            { "mer", "meruy\u00ee" },
            { "mfe", "morisyen\u00ee" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta\u2019" },
            { "mic", "m\u00eekmak\u00ee" },
            { "min", "m\u00eenangkabaw\u00ee" },
            { "mni", "manipuri" },
            { "moe", "\u00een\u00fby\u00eeya rojhilat\u00ee" },
            { "moh", "mohawk\u00ee" },
            { "mos", "morey\u00ee" },
            { "mua", "mundang\u00ee" },
            { "mul", "pirziman\u00ee" },
            { "mus", "kr\u00eek\u00ee" },
            { "mwl", "m\u00eerand\u00ee" },
            { "myv", "erzay\u00ee" },
            { "mzn", "mazenderan\u00ee" },
            { "nap", "napol\u00eetan\u00ee" },
            { "naq", "namay\u00ee" },
            { "nds", "nedersaks\u00ee" },
            { "new", "newar\u00ee" },
            { "nia", "n\u00eeas\u00ee" },
            { "niu", "n\u00eew\u00ee" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogay\u00ee" },
            { "nqo", "n\u2019Ko" },
            { "nso", "sotoy\u00eeya bakur" },
            { "nus", "nuer" },
            { "nyn", "nyankole" },
            { "ojb", "ojibwey\u00eeya bakur\u00ee" },
            { "ojc", "ojibway\u00eeya nav\u00een" },
            { "ojs", "oji-cree" },
            { "ojw", "oj\u00eebwey\u00eeya rojavay\u00ee" },
            { "oka", "okanagan" },
            { "osa", "osagey\u00ee" },
            { "pag", "pangas\u00eenan\u00ee" },
            { "pam", "kapampangan\u00ee" },
            { "pap", "papyamentoy\u00ee" },
            { "pau", "palaw\u00ee" },
            { "pcm", "p\u00eedg\u00een\u00eeya n\u00eejeryay\u00ee" },
            { "pis", "pij\u00een\u00ee" },
            { "pqm", "malecite-passamaquoddy" },
            { "prg", "pr\u00fbsyay\u00ee" },
            { "quc", "k\u2019iche\u2019" },
            { "raj", "rajasthan\u00ee" },
            { "rap", "rapanuy\u00ee" },
            { "rar", "rarotong\u00ee" },
            { "rhg", "rohingyay\u00ee" },
            { "rif", "tarifit" },
            { "rof", "rombo" },
            { "rup", "aroman\u00ee" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "yakut\u00ee" },
            { "saq", "samburuy\u00ee" },
            { "sat", "santal\u00ee" },
            { "sba", "ngambay" },
            { "sbp", "sanguy\u00ee" },
            { "scn", "sic\u00eel\u00ee" },
            { "sco", "skot\u00ee" },
            { "sdh", "kurd\u00eeya ba\u015f\u00fbr\u00ee" },
            { "seh", "sena" },
            { "ses", "sonxay\u00ee" },
            { "shi", "ta\u015felh\u00eet\u00ee" },
            { "shn", "\u015fan\u00ee" },
            { "sid", "s\u00eedamo" },
            { "skr", "sera\u00eek\u00ee" },
            { "slh", "lushootseeda ba\u015f\u00fbr\u00ee" },
            { "sma", "sam\u00eeya ba\u015f\u00fbr" },
            { "smj", "samiya lule" },
            { "smn", "sam\u00eeya \u00eenar\u00ee" },
            { "sms", "sam\u00eeya skolt\u00ee" },
            { "snk", "soninke" },
            { "srn", "siranan\u00ee" },
            { "ssy", "sahoy\u00ee" },
            { "str", "saan\u00ee\u00e7\u00ee" },
            { "suk", "sukuma" },
            { "swb", "komor\u00ee" },
            { "syr", "siryan\u00ee" },
            { "szl", "siles\u00ee" },
            { "tce", "totu\u00e7ena ba\u015f\u00fbr\u00ee" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "tet", "tet\u00fbm\u00ee" },
            { "tgx", "tag\u00ee\u015f\u00ee" },
            { "tht", "tahltan" },
            { "tig", "tigre" },
            { "tlh", "kl\u00eengon\u00ee" },
            { "tli", "tlingit" },
            { "tok", "toki pona" },
            { "tpi", "tokpisin\u00ee" },
            { "trv", "tarokoy\u00ee" },
            { "trw", "torwal\u00ee" },
            { "ttm", "tuto\u00e7en\u00eeya bakur" },
            { "tum", "tumbukay\u00ee" },
            { "tvl", "tuval\u00fby\u00ee" },
            { "twq", "tasawaq" },
            { "tyv", "tuvan\u00ee" },
            { "tzm", "temaz\u00eext\u00ee" },
            { "udm", "udmurt\u00ee" },
            { "umb", "umbunduy\u00ee" },
            { "und", "ziman\u00ea nenas" },
            { "vec", "ven\u00ees\u00ee" },
            { "vmw", "makhuway\u00ee" },
            { "vun", "vunjo" },
            { "wae", "walser\u00ee" },
            { "wal", "wolaytta" },
            { "war", "waray\u00ee" },
            { "wbp", "warlpiri" },
            { "wuu", "\u00e7\u00een\u00eeya wuy\u00ee" },
            { "xal", "kalm\u00eek\u00ee" },
            { "xnr", "kangr\u00ee" },
            { "xog", "sogay\u00ee" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nh\u00eangat\u00fby\u00ee" },
            { "yue", "kanton\u00ee" },
            { "zgh", "amaz\u00eex\u00eeya fas\u00ee" },
            { "zun", "zun\u00eey\u00ee" },
            { "zxx", "b\u00ea naveroka ziman\u00ee" },
            { "zza", "zazak\u00ee (kirdk\u00ee, kirmanck\u00ee)" },
            { "Arab", metaValue_ar },
            { "Aran", "nestal\u00eeq" },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Bopo", "bopomofo" },
            { "Brai", "braille" },
            { "Copt", "qipt\u00ee" },
            { "Cprt", "qibris\u00ee" },
            { "Cyrl", "kir\u00eel\u00ee" },
            { "Deva", "devanagar\u00ee" },
            { "Egyp", "h\u00eeyerogl\u00eef\u00ean misir\u00ee" },
            { "Ethi", "et\u00eeyop\u00eek" },
            { "Geor", metaValue_ka },
            { "Goth", "got\u00eek" },
            { "Grek", metaValue_el },
            { "Gujr", "gujerat\u00ee" },
            { "Hanb", "han\u00eeya bi bopomofoy\u00ea" },
            { "Hang", "hangul\u00ee" },
            { "Hani", "han\u00ee" },
            { "Hans", "sadekir\u00ee" },
            { "Hant", "kevne\u015fop\u00ee" },
            { "Hebr", metaValue_he },
            { "Hira", "h\u00eeraganay\u00ee" },
            { "Hrkt", "niv\u00ees\u00ean hecey\u00ee y\u00ean japon\u00ee" },
            { "Jamo", "jamoy\u00ee" },
            { "Jpan", metaValue_ja },
            { "Kana", "katakanay\u00ee" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", "laoy\u00ee" },
            { "Latn", metaValue_la },
            { "Mlym", "malayam\u00ee" },
            { "Mong", metaValue_mn },
            { "Mymr", "myanmar\u00ee" },
            { "Qaag", "zawgyi" },
            { "Sinh", "s\u00eenhalay\u00ee" },
            { "Taml", metaValue_ta },
            { "Telu", "teluguy\u00ee" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Yezi", "\u00eazid\u00ee" },
            { "Zmth", "n\u00ee\u015fandana matemat\u00eek\u00ee" },
            { "Zsye", "emoj\u00ee" },
            { "Zsym", "sembol" },
            { "Zxxx", "neniv\u00eesk\u00ee" },
            { "Zyyy", "hevpar" },
            { "Zzzz", "alfabeya nenas" },
            { "en_GB", "\u00eengil\u00eez\u00ee (Qiral\u00eeyeta Yekb\u00fby\u00ee)" },
            { "es_ES", "span\u00ee (Ewropa)" },
            { "fa_AF", "der\u00ee" },
            { "fr_CA", "fransiz\u00ee (Kanada)" },
            { "fr_CH", "fransiz\u00ee (Sw\u00eesre)" },
            { "nl_BE", "flam\u00ee" },
            { "pt_PT", "portugal\u00ee (Ewropa)" },
            { "sw_CD", "swah\u00eel\u00eeya kongoy\u00ee" },
            { "ar_001", "ereb\u00eeya modern a standard" },
            { "key.ca", "Salname" },
            { "key.co", "R\u00eazkirin" },
            { "key.cu", "diw\u00eez" },
            { "zh_Hans", "\u00e7\u00een\u00eeya sadekir\u00ee" },
            { "zh_Hant", "\u00e7\u00een\u00eeya kevne\u015fop\u00ee" },
            { "%%1959ACAD", "Akadem\u00eek" },
            { "type.ca.roc", "Salnameya Komara \u00c7\u00een\u00ea" },
            { "type.nu.arab", "Reqem\u00ean hindo-ereb\u00ee" },
            { "type.nu.latn", "Reqem\u00ean Rojavay\u00ee" },
            { "type.ca.dangi", "Salnameya Dang\u00ee" },
            { "type.nu.roman", "Reqem\u00ean Romay\u00ee" },
            { "type.ca.coptic", "Salnameya Qipt\u00ee" },
            { "type.ca.hebrew", "salnameya \u00eebran\u00ee" },
            { "type.ca.indian", "Salnameya Mil\u00ee ya Hind\u00ee" },
            { "type.ca.chinese", "Salnameya \u00c7\u00een\u00ee" },
            { "type.ca.islamic", "Salnameya Hicr\u00ee" },
            { "type.ca.iso8601", "Salnameya ISO-8601\u00ea" },
            { "type.ca.persian", "Salnameya \u00ceran\u00ee" },
            { "type.ca.buddhist", "Salnameya Bud\u00eest" },
            { "type.ca.ethiopic", "Salnameya Et\u00eeyop\u00eek" },
            { "type.ca.japanese", "Salnameya Japon\u00ee" },
            { "type.co.standard", "Away\u00ea R\u00eazkirina Standard" },
            { "type.ca.gregorian", "Salnameya M\u00eelad\u00ee" },
            { "type.ca.islamic-rgsa", "Salnameya Hicr\u00ee (Siud\u00ee)" },
            { "type.ca.islamic-tbla", "Salnameya Hicr\u00ee (15\u00ea t\u00eermeha 622yan)" },
            { "type.ca.islamic-civil", "Salnameya Hicr\u00ee (16\u00ea t\u00eermeha 622yan)" },
            { "type.ca.islamic-umalqura", "Salnameya Hicr\u00ee (Um el-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Salnameya Amete Alem ya Et\u00eeyop\u00eek" },
        };
        return data;
    }
}
