/*
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package jdk.jshell.spi;

/**
 * The construction and throw of this exception is embedded in code generated by
 * the JShell core implementation in such a way that, upon executing a
 * {@link jdk.jshell.Snippet.Status#RECOVERABLE_DEFINED RECOVERABLE_DEFINED}
 * user method, this exception is thrown.
 * <p>
 * This exception is seen by the execution engine, but not seen by
 * the end user nor through the JShell API.
 *
 * @since 9
 */
@SuppressWarnings("serial")             // serialVersionUID intentionally omitted
public class SPIResolutionException extends RuntimeException {

    /** @serial */
    private final int id;

    /**
     * Constructs an SPI layer exception indicating that a
     * {@code DeclarationSnippet} with unresolved references has been
     * encountered. The throw of this exception is generated into the body of a
     * {@link jdk.jshell.Snippet.Status#RECOVERABLE_DEFINED RECOVERABLE_DEFINED}
     * method.
     *
     * @param id An internal identifier of the specific method
     */
    public SPIResolutionException(int id) {
        super("resolution exception");
        this.id = id;
    }

    /**
     * Retrieves the internal identifier of the unresolved identifier.
     *
     * @return the internal identifier
     */
    public int id() {
        return id;
    }
}
