/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sr_Latn extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Srednje vreme po Grini\u010du",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Akre standardno vreme",
               "",
               "Akre letnje ra\u010dunanje vremena",
               "",
               "Akre vreme",
               "",
            };
        final String[] Apia = new String[] {
               "Apija, standardno vreme",
               "",
               "Apija, letnje vreme",
               "",
               "Apija vreme",
               "",
            };
        final String[] Cook = new String[] {
               "Kukova ostrva, standardno vreme",
               "",
               "Kukova ostrva, polu-letnje vreme",
               "",
               "Kukova ostrva vreme",
               "",
            };
        final String[] Cuba = new String[] {
               "Kuba, standardno vreme",
               "CST",
               "Kuba, letnje vreme",
               "CDT",
               "Kuba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fid\u017ei, standardno vreme",
               "",
               "Fid\u017ei, letnje vreme",
               "",
               "Fid\u017ei vreme",
               "",
            };
        final String[] Gulf = new String[] {
               "Zalivsko vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovd, standardno vreme",
               "",
               "Hovd, letnje vreme",
               "",
               "Hovd vreme",
               "",
            };
        final String[] Iran = new String[] {
               "Iran, standardno vreme",
               "",
               "Iran, letnje vreme",
               "",
               "Iran vreme",
               "",
            };
        final String[] Niue = new String[] {
               "Niue vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsk, standardno vreme",
               "",
               "Omsk, letnje vreme",
               "",
               "Omsk vreme",
               "",
            };
        final String[] Peru = new String[] {
               "Peru, standardno vreme",
               "",
               "Peru, letnje vreme",
               "",
               "Peru vreme",
               "",
            };
        final String[] Truk = new String[] {
               "\u010cuuk vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Vejk ostrvo vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "\u010cile, standardno vreme",
               "",
               "\u010cile, letnje vreme",
               "",
               "\u010cile vreme",
               "",
            };
        final String[] China = new String[] {
               "Kinesko standardno vreme",
               "CST",
               "Kina, letnje vreme",
               "CDT",
               "Kina vreme",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Kokos (Keling) Ostrva vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Dejvis vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Indijsko standardno vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Japansko standardno vreme",
               "JST",
               "Japansko letnje vreme",
               "JDT",
               "Japansko vreme",
               "JT",
            };
        final String[] Korea = new String[] {
               "Korejsko standardno vreme",
               "KST",
               "Korejsko letnje vreme",
               "KST",
               "Korejsko vreme",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nauru vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepal vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palau vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa, standardno vreme",
               "SST",
               "Samoa, letnje vreme",
               "SST",
               "Samoa vreme",
               "SST",
            };
        final String[] Syowa = new String[] {
               "\u0160ova vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tonga, standardno vreme",
               "",
               "Tonga, letnje vreme",
               "",
               "Tonga vreme",
               "",
            };
        final String[] Yukon = new String[] {
               "Jukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Aljaska, standardno vreme",
               "AKST",
               "Aljaska, letnje vreme",
               "AKDT",
               "Aljaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amazon, standardno vreme",
               "",
               "Amazon, letnje vreme",
               "",
               "Amazon vreme",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anadir standardno vreme",
               "",
               "Anadir letnje ra\u010dunanje vremena",
               "",
               "Anadir vreme",
               "",
            };
        final String[] Azores = new String[] {
               "Azori, standardno vreme",
               "",
               "Azori, letnje vreme",
               "",
               "Azori vreme",
               "",
            };
        final String[] Bhutan = new String[] {
               "Butan vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunej Darusalum vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Uskr\u0161nja ostrva, standardno vreme",
               "",
               "Uskr\u0161nja ostrva, letnje vreme",
               "",
               "Uskr\u0161nja ostrva vreme",
               "",
            };
        final String[] Guyana = new String[] {
               "Gvajana vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Izraelsko standardno vreme",
               "IST",
               "Izraelsko letnje vreme",
               "IDT",
               "Izraelsko vreme",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Ko\u0161re vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Moson vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskva, standardno vreme",
               "MSK",
               "Moskva, letnje vreme",
               "MSK",
               "Moskva vreme",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponpej vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Samara standardno vreme",
               "",
               "Samara letnje ra\u010dunanje vremena",
               "",
               "Samara vreme",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahiti vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Tajpej, standardno vreme",
               "CST",
               "Tajpej, letnje vreme",
               "CDT",
               "Tajpej vreme",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostok vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Valis i Futuna Ostrva vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabijsko standardno vreme",
               "",
               "Arabijsko letnje vreme",
               "",
               "Arabijsko vreme",
               "",
            };
        final String[] Armenia = new String[] {
               "Jermenija, standardno vreme",
               "",
               "Jermenija, letnje vreme",
               "",
               "Jermenija vreme",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolivija vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "\u010catam, standardno vreme",
               "",
               "\u010catam, letnje vreme",
               "",
               "\u010catam vreme",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Koordinisano univerzalno vreme",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ekvador vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambije vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Gruzija, standardno vreme",
               "",
               "Gruzija, letnje vreme",
               "",
               "Gruzija vreme",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkuck, standardno vreme",
               "",
               "Irkuck, letnje vreme",
               "",
               "Irkuck vreme",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadan, standardno vreme",
               "",
               "Magadan, letnje vreme",
               "",
               "Magadan vreme",
               "",
            };
        final String[] Myanmar = new String[] {
               "Mijanmar vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolk Ostrvo, standardno vreme",
               "",
               "Norfolk Ostrvo, letnje vreme",
               "",
               "Norfolk Ostrvo vreme",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronja, standardno vreme",
               "",
               "Fernando de Noronja, letnje vreme",
               "",
               "Fernando de Noronja vreme",
               "",
            };
        final String[] Reunion = new String[] {
               "Reinion vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rotera vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Solomonska Ostrva vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Urugvaj, standardno vreme",
               "",
               "Urugvaj, letnje vreme",
               "",
               "Urugvaj vreme",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu, standardno vreme",
               "",
               "Vanuatu, letnje vreme",
               "",
               "Vanuatu vreme",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakutsk, standardno vreme",
               "",
               "Jakutsk, letnje vreme",
               "",
               "Jakutsk vreme",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantsko standardno vreme",
               "AST",
               "Atlantsko letnje vreme",
               "ADT",
               "Atlantsko vreme",
               "AT",
            };
        final String[] Brasilia = new String[] {
               "Brazilija, standardno vreme",
               "",
               "Brazilija, letnje vreme",
               "",
               "Brazilija vreme",
               "",
            };
        final String[] Chamorro = new String[] {
               "\u010camoro vreme",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Kolumbija, standardno vreme",
               "",
               "Kolumbija, letnje vreme",
               "",
               "Kolumbija vreme",
               "",
            };
        final String[] Falkland = new String[] {
               "Folklandska Ostrva, standardno vreme",
               "",
               "Folklandska Ostrva, letnje vreme",
               "",
               "Folklandska Ostrva vreme",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malezija vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldivi vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulan Bator, standardno vreme",
               "",
               "Ulan Bator, letnje vreme",
               "",
               "Ulan Bator vreme",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistan, standardno vreme",
               "PKT",
               "Pakistan, letnje vreme",
               "PKST",
               "Pakistan vreme",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paragvaj, standardno vreme",
               "",
               "Paragvaj, letnje vreme",
               "",
               "Paragvaj vreme",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitkern vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sahalin, standardno vreme",
               "",
               "Sahalin, letnje vreme",
               "",
               "Sahalin vreme",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinam vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentina, standardno vreme",
               "",
               "Argentina, letnje vreme",
               "",
               "Argentina vreme",
               "",
            };
        final String[] Christmas = new String[] {
               "Bo\u017ei\u0107no ostrvo vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagos vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hong Kong, standardno vreme",
               "HKT",
               "Hong Kong, letnje vreme",
               "HKST",
               "Hong Kong vreme",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Indokina vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsko-kam\u010datsko standardno vreme",
               "",
               "Petropavlovsko-kam\u010datsko letnje ra\u010dunanje vremena",
               "",
               "Petropavlovsko-kam\u010datsko vreme",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgistan vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Hov, standardno vreme",
               "",
               "Lord Hov, letnje vreme",
               "",
               "Lord Hov vreme",
               "",
            };
        final String[] Marquesas = new String[] {
               "Markiz vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauricijus, standardno vreme",
               "",
               "Mauricijus, letnje vreme",
               "",
               "Mauricijus vreme",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapur, standardno vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venecuela vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Volgograd, standardno vreme",
               "MSK",
               "Volgograd, letnje vreme",
               "MSK",
               "Volgograd vreme",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbejd\u017ean, standardno vreme",
               "",
               "Azerbejd\u017ean, letnje vreme",
               "",
               "Azerbejd\u017ean vreme",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Banglade\u0161, standardno vreme",
               "",
               "Banglade\u0161, letnje vreme",
               "",
               "Banglade\u0161 vreme",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Zelenortska Ostrva, standardno vreme",
               "",
               "Zelenortska Ostrva, letnje vreme",
               "",
               "Zelenortska Ostrva vreme",
               "",
            };
        final String[] East_Timor = new String[] {
               "Isto\u010dni timor vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Sej\u0161eli vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tad\u017eikistan vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbekistan, standardno vreme",
               "",
               "Uzbekistan, letnje vreme",
               "",
               "Uzbekistan vreme",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Avganistan vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsk, standardno vreme",
               "",
               "Krasnojarsk, letnje vreme",
               "",
               "Krasnojarsk vreme",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Novi Zeland, standardno vreme",
               "NZST",
               "Novi Zeland, letnje vreme",
               "NZDT",
               "Novi Zeland vreme",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk, standardno vreme",
               "",
               "Novosibirsk, letnje vreme",
               "",
               "Novosibirsk vreme",
               "",
            };
        final String[] Philippines = new String[] {
               "Filipini, standardno vreme",
               "PST",
               "Filipini, letnje vreme",
               "PDT",
               "Filipini vreme",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok, standardno vreme",
               "",
               "Vladivostok, letnje vreme",
               "",
               "Vladivostok vreme",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indijsko okeansko vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Ostrva Lajn vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Njufaundlend, standardno vreme",
               "NST",
               "Njufaundlend, letnje vreme",
               "NDT",
               "Njufaundlend",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistan, standardno vreme",
               "",
               "Turkmenistan, letnje vreme",
               "",
               "Turkmenistan vreme",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Francuska Gvajana vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Nova Kaledonija, standardno vreme",
               "",
               "Nova Kaledonija, letnje vreme",
               "",
               "Nova Kaledonija vreme",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Ju\u017ena D\u017eord\u017eija vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburg, standardno vreme",
               "",
               "Jekaterinburg, letnje vreme",
               "",
               "Jekaterinburg vreme",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Centralno-afri\u010dko vreme",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Isto\u010dno-afri\u010dko vreme",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Zapadno-afri\u010dko standardno vreme",
               "WAT",
               "Zapadno-afri\u010dko letnje vreme",
               "WAT",
               "Zapadno-afri\u010dko vreme",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Dimon d\u2019Urvil vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Srednjeevropsko standardno vreme",
               "CET",
               "Srednjeevropsko letnje vreme",
               "CEST",
               "Srednjeevropsko vreme",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Isto\u010dnoevropsko standardno vreme",
               "EET",
               "Isto\u010dnoevropsko letnje vreme",
               "EEST",
               "Isto\u010dnoevropsko vreme",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Zapadnoevropsko standardno vreme",
               "WET",
               "Zapadnoevropsko letnje vreme",
               "WEST",
               "Zapadnoevropsko vreme",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Meksi\u010dki Pacifik, standardno vreme",
               "MST",
               "Meksi\u010dki Pacifik, letnje vreme",
               "MDT",
               "Meksi\u010dki Pacifik",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Ju\u017eno-afri\u010dko vreme",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Severnoameri\u010dko centralno standardno vreme",
               "CST",
               "Severnoameri\u010dko centralno letnje vreme",
               "CDT",
               "Severnoameri\u010dko centralno vreme",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Severnoameri\u010dko isto\u010dno standardno vreme",
               "EST",
               "Severnoameri\u010dko isto\u010dno letnje vreme",
               "EST",
               "Severnoameri\u010dko isto\u010dno vreme",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Severnoameri\u010dko pacifi\u010dko standardno vreme",
               "PST",
               "Severnoameri\u010dko pacifi\u010dko letnje vreme",
               "PDT",
               "Severnoameri\u010dko pacifi\u010dko vreme",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Francusko ju\u017eno i antarkti\u010dko vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbert ostrva vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Havajsko-aleutsko standardno vreme",
               "HST",
               "Havajsko-aleutsko letnje vreme",
               "HST",
               "Havajsko-aleutsko vreme",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Feniks ostrva vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Sen Pjer i Mikelon, standardno vreme",
               "",
               "Sen Pjer i Mikelon, letnje vreme",
               "",
               "Sen Pjer i Mikelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Severnoameri\u010dko planinsko standardno vreme",
               "MST",
               "Severnoameri\u010dko planinsko letnje vreme",
               "MST",
               "Severnoameri\u010dko planinsko vreme",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Mar\u0161alska Ostrva vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Severozapadni Meksiko, standardno vreme",
               "",
               "Severozapadni Meksiko, letnje vreme",
               "",
               "Severozapadni Meksiko",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua Nova Gvineja vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Australijsko centralno standardno vreme",
               "ACST",
               "Australijsko centralno letnje vreme",
               "ACDT",
               "Australijsko centralno vreme",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Australijsko isto\u010dno standardno vreme",
               "AEST",
               "Australijsko isto\u010dno letnje vreme",
               "AEDT",
               "Australijsko isto\u010dno vreme",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Australijsko zapadno standardno vreme",
               "AWST",
               "Australijsko zapadno letnje vreme",
               "AWDT",
               "Australijsko zapadno vreme",
               "AWT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Isto\u010dni Grenland, standardno vreme",
               "",
               "Isto\u010dni Grenland, letnje vreme",
               "",
               "Isto\u010dni Grenland",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Zapadni Grenland, standardno vreme",
               "",
               "Zapadni Grenland, letnje vreme",
               "",
               "Zapadni Grenland",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Centralno-indonezijsko vreme",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Isto\u010dno-indonezijsko vreme",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Zapadno-indonezijsko vreme",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Isto\u010dno-kazahstansko vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Zapadno-kazahstansko vreme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Australijsko centralno zapadno standardno vreme",
               "",
               "Australijsko centralno zapadno letnje vreme",
               "",
               "Australijsko centralno zapadno vreme",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "SST", Solomon },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UTC", ETC_UTC },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Truk },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Malaysia },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Srednje vreme po Grini\u010du",
                    "GMT",
                    "Irska, standardno vreme",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Srednje vreme po Grini\u010du",
                    "GMT",
                    "Britanija, letnje vreme",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Srednje vreme po Grini\u010du",
                    "GMT",
                    "Britanija, letnje vreme",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Easter", Easter },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Ponape },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Pacific/Wallis", Wallis },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Aden" },
            { "timezone.excity.Asia/Baku", "Baku" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Gaza", "Gaza" },
            { "timezone.excity.Asia/Hovd", "Hovd" },
            { "timezone.excity.Asia/Omsk", "Omsk" },
            { "timezone.excity.Asia/Oral", "Oral" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Aman" },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "\u010cita" },
            { "timezone.excity.Asia/Dhaka", "Daka" },
            { "timezone.excity.Asia/Dubai", "Dubai" },
            { "timezone.excity.Asia/Kabul", "Kabul" },
            { "timezone.excity.Asia/Macau", "Makao" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.Asia/Seoul", "Seul" },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "timezone.excity.Asia/Tomsk", "Tomsk" },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "D\u017euba" },
            { "timezone.excity.Africa/Lome", "Lome" },
            { "timezone.excity.Asia/Almaty", "Almati" },
            { "timezone.excity.Asia/Anadyr", "Anadir" },
            { "timezone.excity.Asia/Aqtobe", "Akutobe" },
            { "timezone.excity.Asia/Atyrau", "Atirau" },
            { "timezone.excity.Asia/Beirut", "Bejrut" },
            { "timezone.excity.Asia/Brunei", "Brunej" },
            { "timezone.excity.Asia/Hebron", "Hebron" },
            { "timezone.excity.Asia/Kuwait", "Kuvajt" },
            { "timezone.excity.Asia/Manila", "Manila" },
            { "timezone.excity.Asia/Muscat", "Muskat" },
            { "timezone.excity.Asia/Riyadh", "Rijad" },
            { "timezone.excity.Asia/Saigon", "Ho \u0160i Min" },
            { "timezone.excity.Asia/Taipei", "Tajpej" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Asia/Urumqi", "Urum\u0107i" },
            { "timezone.excity.Etc/Unknown", "Nepoznat grad" },
            { "timezone.excity.Europe/Kiev", "Kijev" },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "timezone.excity.Europe/Riga", "Riga" },
            { "timezone.excity.Europe/Rome", "Rim" },
            { "timezone.excity.Indian/Mahe", "Mahe" },
            { "timezone.excity.Africa/Accra", "Akra" },
            { "timezone.excity.Africa/Cairo", "Kairo" },
            { "timezone.excity.Africa/Ceuta", "Seuta" },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Tunis", "Tunis" },
            { "timezone.excity.America/Adak", "Adak" },
            { "timezone.excity.America/Lima", "Lima" },
            { "timezone.excity.America/Nome", "Nom" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bahrain", "Bahrein" },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "timezone.excity.Asia/Barnaul", "Barnaul" },
            { "timezone.excity.Asia/Bishkek", "Bi\u0161kek" },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Asia/Irkutsk", "Irkuck" },
            { "timezone.excity.Asia/Jakarta", "D\u017eakarta" },
            { "timezone.excity.Asia/Karachi", "Kara\u010di" },
            { "timezone.excity.Asia/Kuching", "Ku\u010ding" },
            { "timezone.excity.Asia/Magadan", "Magadan" },
            { "timezone.excity.Asia/Nicosia", "Nikozija" },
            { "timezone.excity.Asia/Rangoon", "Rangun" },
            { "timezone.excity.Asia/Tbilisi", "Tbilisi" },
            { "timezone.excity.Asia/Thimphu", "Timpu" },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Asia/Yerevan", "Jerevan" },
            { "timezone.excity.Europe/Kirov", "Kirov" },
            { "timezone.excity.Europe/Malta", "Malta" },
            { "timezone.excity.Europe/Minsk", "Minsk" },
            { "timezone.excity.Europe/Paris", "Pariz" },
            { "timezone.excity.Europe/Sofia", "Sofija" },
            { "timezone.excity.Europe/Vaduz", "Vaduz" },
            { "timezone.excity.Indian/Cocos", "Kokos" },
            { "timezone.excity.Pacific/Apia", "Apija" },
            { "timezone.excity.Pacific/Fiji", "Fid\u017ei" },
            { "timezone.excity.Pacific/Guam", "Guam" },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "timezone.excity.Pacific/Truk", "Truk" },
            { "timezone.excity.Pacific/Wake", "Vejk" },
            { "timezone.excity.Africa/Asmera", "Asmera" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Banjul", "Ban\u017eul" },
            { "timezone.excity.Africa/Bissau", "Bisao" },
            { "timezone.excity.Africa/Douala", "Duala" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "timezone.excity.Africa/Maputo", "Maputo" },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "timezone.excity.Africa/Niamey", "Nijamej" },
            { "timezone.excity.America/Aruba", "Aruba" },
            { "timezone.excity.America/Bahia", "Baija" },
            { "timezone.excity.America/Belem", "Belem" },
            { "timezone.excity.America/Boise", "Bojzi" },
            { "timezone.excity.America/Jujuy", "\u017du\u017eui" },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "timezone.excity.America/Thule", "Tul" },
            { "timezone.excity.Asia/Ashgabat", "A\u0161habad" },
            { "timezone.excity.Asia/Calcutta", "Kalkuta" },
            { "timezone.excity.Asia/Damascus", "Damask" },
            { "timezone.excity.Asia/Dushanbe", "Du\u0161anbe" },
            { "timezone.excity.Asia/Jayapura", "D\u017eajapura" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.Asia/Khandyga", "Handiga" },
            { "timezone.excity.Asia/Makassar", "Makasar" },
            { "timezone.excity.Asia/Qostanay", "Kostanaj" },
            { "timezone.excity.Asia/Sakhalin", "Sahalin" },
            { "timezone.excity.Asia/Shanghai", "\u0160angaj" },
            { "timezone.excity.Asia/Tashkent", "Ta\u0161kent" },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Nera" },
            { "timezone.excity.Europe/Athens", "Atina" },
            { "timezone.excity.Europe/Berlin", "Berlin" },
            { "timezone.excity.Europe/Dublin", "Dablin" },
            { "timezone.excity.Europe/Jersey", "D\u017eerzi" },
            { "timezone.excity.Europe/Lisbon", "Lisabon" },
            { "timezone.excity.Europe/London", "London" },
            { "timezone.excity.Europe/Madrid", "Madrid" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "timezone.excity.Europe/Moscow", "Moskva" },
            { "timezone.excity.Europe/Prague", "Prag" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "timezone.excity.Europe/Skopje", "Skoplje" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Be\u010d" },
            { "timezone.excity.Europe/Warsaw", "Var\u0161ava" },
            { "timezone.excity.Europe/Zagreb", "Zagreb" },
            { "timezone.excity.Europe/Zurich", "Cirih" },
            { "timezone.excity.Indian/Chagos", "\u010cagos" },
            { "timezone.excity.Indian/Comoro", "Komoro" },
            { "timezone.excity.Pacific/Efate", "Efat" },
            { "timezone.excity.Pacific/Nauru", "Nauru" },
            { "timezone.excity.Pacific/Palau", "Palau" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abid\u017ean" },
            { "timezone.excity.Africa/Algiers", "Al\u017eir" },
            { "timezone.excity.Africa/Conakry", "Konakri" },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.Africa/Nairobi", "Najrobi" },
            { "timezone.excity.Africa/Tripoli", "Tripoli" },
            { "timezone.excity.America/Belize", "Belize" },
            { "timezone.excity.America/Bogota", "Bogota" },
            { "timezone.excity.America/Cancun", "Kankun" },
            { "timezone.excity.America/Cayman", "Kajmanska Ostrva" },
            { "timezone.excity.America/Cuiaba", "Kuiaba" },
            { "timezone.excity.America/Dawson", "Doson" },
            { "timezone.excity.America/Denver", "Denver" },
            { "timezone.excity.America/Guyana", "Gvajana" },
            { "timezone.excity.America/Havana", "Havana" },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "timezone.excity.America/Juneau", "\u017duno" },
            { "timezone.excity.America/La_Paz", "La Paz" },
            { "timezone.excity.America/Maceio", "Masejo" },
            { "timezone.excity.America/Manaus", "Manaus" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.America/Nassau", "Nasau" },
            { "timezone.excity.America/Panama", "Panama" },
            { "timezone.excity.America/Recife", "Resife" },
            { "timezone.excity.America/Regina", "Regina" },
            { "timezone.excity.Asia/Famagusta", "Famagusta" },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.Asia/Jerusalem", "Jerusalim" },
            { "timezone.excity.Asia/Kamchatka", "Kam\u010datka" },
            { "timezone.excity.Asia/Pontianak", "Pontijanak" },
            { "timezone.excity.Asia/Pyongyang", "Pjongjang" },
            { "timezone.excity.Asia/Qyzylorda", "Kizilorda" },
            { "timezone.excity.Asia/Samarkand", "Samarkand" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "timezone.excity.Asia/Vientiane", "Vijentijan" },
            { "timezone.excity.Europe/Andorra", "Andora" },
            { "timezone.excity.Europe/Saratov", "Saratov" },
            { "timezone.excity.Europe/Tallinn", "Talin" },
            { "timezone.excity.Europe/Vatican", "Vatikan" },
            { "timezone.excity.Europe/Vilnius", "Vilnjus" },
            { "timezone.excity.Indian/Mayotte", "Majot" },
            { "timezone.excity.Indian/Reunion", "Reunion" },
            { "timezone.excity.Pacific/Easter", "Uskr\u0161nje ostrvo" },
            { "timezone.excity.Pacific/Kanton", "Kanton" },
            { "timezone.excity.Pacific/Kosrae", "Ko\u0161re" },
            { "timezone.excity.Pacific/Majuro", "Majuro" },
            { "timezone.excity.Pacific/Midway", "Midvej" },
            { "timezone.excity.Pacific/Noumea", "Numea" },
            { "timezone.excity.Pacific/Ponape", "Ponape" },
            { "timezone.excity.Pacific/Saipan", "Sajpan" },
            { "timezone.excity.Pacific/Tahiti", "Tahiti" },
            { "timezone.excity.Pacific/Tarawa", "Tarava" },
            { "timezone.excity.Pacific/Wallis", "Valis" },
            { "timezone.excity.Africa/Blantyre", "Blantir" },
            { "timezone.excity.Africa/Djibouti", "D\u017eibuti" },
            { "timezone.excity.Africa/El_Aaiun", "El Ajun" },
            { "timezone.excity.Africa/Freetown", "Fritaun" },
            { "timezone.excity.Africa/Gaborone", "Gaboron" },
            { "timezone.excity.Africa/Khartoum", "Kartum" },
            { "timezone.excity.Africa/Kinshasa", "Kin\u0161asa" },
            { "timezone.excity.Africa/Monrovia", "Monrovija" },
            { "timezone.excity.Africa/Ndjamena", "Nd\u017eamena" },
            { "timezone.excity.Africa/Sao_Tome", "Sao Tome" },
            { "timezone.excity.Africa/Windhoek", "Vindhuk" },
            { "timezone.excity.America/Antigua", "Antigva" },
            { "timezone.excity.America/Caracas", "Karakas" },
            { "timezone.excity.America/Cayenne", "Kajen" },
            { "timezone.excity.America/Chicago", "\u010cikago" },
            { "timezone.excity.America/Cordoba", "Kordoba" },
            { "timezone.excity.America/Creston", "Kreston" },
            { "timezone.excity.America/Curacao", "Kurasao" },
            { "timezone.excity.America/Detroit", "Detroit" },
            { "timezone.excity.America/Godthab", "Gothab" },
            { "timezone.excity.America/Grenada", "Grenada" },
            { "timezone.excity.America/Halifax", "Halifaks" },
            { "timezone.excity.America/Iqaluit", "Ikvaluit" },
            { "timezone.excity.America/Jamaica", "Jamajka" },
            { "timezone.excity.America/Managua", "Managva" },
            { "timezone.excity.America/Marigot", "Marigo" },
            { "timezone.excity.America/Mendoza", "Mendosa" },
            { "timezone.excity.America/Moncton", "Monkton" },
            { "timezone.excity.America/Nipigon", "Nipigon" },
            { "timezone.excity.America/Noronha", "Noronja" },
            { "timezone.excity.America/Ojinaga", "Ohinaga" },
            { "timezone.excity.America/Phoenix", "Finiks" },
            { "timezone.excity.America/Tijuana", "Tihuana" },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "timezone.excity.America/Tortola", "Tortola" },
            { "timezone.excity.America/Yakutat", "Jakutat" },
            { "timezone.excity.Asia/Choibalsan", "\u010cojbalsan" },
            { "timezone.excity.Asia/Phnom_Penh", "Pnom Pen" },
            { "timezone.excity.Atlantic/Azores", "Azori" },
            { "timezone.excity.Atlantic/Canary", "Kanarska ostrva" },
            { "timezone.excity.Atlantic/Faeroe", "Farska Ostrva" },
            { "timezone.excity.Australia/Eucla", "Iukla" },
            { "timezone.excity.Australia/Perth", "Pert" },
            { "timezone.excity.Europe/Belgrade", "Beograd" },
            { "timezone.excity.Europe/Brussels", "Brisel" },
            { "timezone.excity.Europe/Budapest", "Budimpe\u0161ta" },
            { "timezone.excity.Europe/Busingen", "Bisingen" },
            { "timezone.excity.Europe/Chisinau", "Ki\u0161injev" },
            { "timezone.excity.Europe/Guernsey", "Gernzi" },
            { "timezone.excity.Europe/Helsinki", "Helsinki" },
            { "timezone.excity.Europe/Istanbul", "Istanbul" },
            { "timezone.excity.Europe/Sarajevo", "Sarajevo" },
            { "timezone.excity.Europe/Uzhgorod", "U\u017egorod" },
            { "timezone.excity.Indian/Maldives", "Maldivi" },
            { "timezone.excity.Pacific/Chatham", "\u010catam" },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofo" },
            { "timezone.excity.Pacific/Gambier", "Gambije" },
            { "timezone.excity.Pacific/Norfolk", "Norfolk" },
            { "timezone.excity.Africa/Bujumbura", "Bud\u017eumbura" },
            { "timezone.excity.Africa/Mogadishu", "Mogadi\u0161" },
            { "timezone.excity.America/Anguilla", "Angvila" },
            { "timezone.excity.America/Asuncion", "Asunsion" },
            { "timezone.excity.America/Barbados", "Barbados" },
            { "timezone.excity.America/Dominica", "Dominika" },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.America/Eirunepe", "Eirunepe" },
            { "timezone.excity.America/Mazatlan", "Mazatlan" },
            { "timezone.excity.America/Miquelon", "Mikelon" },
            { "timezone.excity.America/New_York", "Njujork" },
            { "timezone.excity.America/Resolute", "Resolut" },
            { "timezone.excity.America/Santarem", "Santarem" },
            { "timezone.excity.America/Santiago", "Santjago" },
            { "timezone.excity.America/St_Johns", "Sv. D\u017eon" },
            { "timezone.excity.America/St_Kitts", "Sent Kits" },
            { "timezone.excity.America/St_Lucia", "Sv. Lucija" },
            { "timezone.excity.America/Winnipeg", "Vinipeg" },
            { "timezone.excity.Antarctica/Casey", "Kejsi" },
            { "timezone.excity.Antarctica/Davis", "Dejvis" },
            { "timezone.excity.Antarctica/Syowa", "\u0160ova" },
            { "timezone.excity.Antarctica/Troll", "Trol" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulan Bator" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "timezone.excity.Atlantic/Bermuda", "Bermuda" },
            { "timezone.excity.Atlantic/Madeira", "Madeira" },
            { "timezone.excity.Atlantic/Stanley", "Stenli" },
            { "timezone.excity.Australia/Currie", "Kari" },
            { "timezone.excity.Australia/Darwin", "Darvin" },
            { "timezone.excity.Australia/Hobart", "Hobart" },
            { "timezone.excity.Australia/Sydney", "Sidnej" },
            { "timezone.excity.Europe/Amsterdam", "Amsterdam" },
            { "timezone.excity.Europe/Astrakhan", "Astrakan" },
            { "timezone.excity.Europe/Bucharest", "Bukure\u0161t" },
            { "timezone.excity.Europe/Gibraltar", "Gibraltar" },
            { "timezone.excity.Europe/Ljubljana", "Ljubljana" },
            { "timezone.excity.Europe/Mariehamn", "Marihamn" },
            { "timezone.excity.Europe/Podgorica", "Podgorica" },
            { "timezone.excity.Europe/Stockholm", "Stokholm" },
            { "timezone.excity.Europe/Ulyanovsk", "Uljanovsk" },
            { "timezone.excity.Europe/Volgograd", "Volgograd" },
            { "timezone.excity.Indian/Christmas", "Bo\u017ei\u0107" },
            { "timezone.excity.Indian/Kerguelen", "Kergelen" },
            { "timezone.excity.Indian/Mauritius", "Mauricijus" },
            { "timezone.excity.Pacific/Auckland", "Okland" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Pacific/Johnston", "D\u017eonston" },
            { "timezone.excity.Pacific/Pitcairn", "Pitkern" },
            { "timezone.excity.Africa/Casablanca", "Kazablanka" },
            { "timezone.excity.Africa/Libreville", "Librevil" },
            { "timezone.excity.Africa/Lubumbashi", "Lubumba\u0161i" },
            { "timezone.excity.Africa/Nouakchott", "Nuak\u0161ot" },
            { "timezone.excity.Africa/Porto-Novo", "Porto Novo" },
            { "timezone.excity.America/Anchorage", "Enkorid\u017e" },
            { "timezone.excity.America/Araguaina", "Aragvajana" },
            { "timezone.excity.America/Boa_Vista", "Boa Vista" },
            { "timezone.excity.America/Catamarca", "Katamarka" },
            { "timezone.excity.America/Chihuahua", "\u010cihuahua" },
            { "timezone.excity.America/Fortaleza", "Fortaleza" },
            { "timezone.excity.America/Glace_Bay", "Glejs Bej" },
            { "timezone.excity.America/Goose_Bay", "Gus Bej" },
            { "timezone.excity.America/Guatemala", "Gvatemala" },
            { "timezone.excity.America/Guayaquil", "Gvajakil" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "timezone.excity.America/Menominee", "Menomini" },
            { "timezone.excity.America/Monterrey", "Monterej" },
            { "timezone.excity.America/Sao_Paulo", "Sao Paolo" },
            { "timezone.excity.America/St_Thomas", "Sv. Toma" },
            { "timezone.excity.America/Vancouver", "Vankuver" },
            { "timezone.excity.Antarctica/Mawson", "Moson" },
            { "timezone.excity.Antarctica/Palmer", "Palmer" },
            { "timezone.excity.Antarctica/Vostok", "Vostok" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lumpur" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuznjeck" },
            { "timezone.excity.Europe/Bratislava", "Bratislava" },
            { "timezone.excity.Europe/Copenhagen", "Kopenhagen" },
            { "timezone.excity.Europe/Luxembourg", "Luksemburg" },
            { "timezone.excity.Europe/San_Marino", "San Marino" },
            { "timezone.excity.Europe/Simferopol", "Simferopolj" },
            { "timezone.excity.Europe/Zaporozhye", "Zaporo\u017eje" },
            { "timezone.excity.Pacific/Enderbury", "Enderberi" },
            { "timezone.excity.Pacific/Galapagos", "Galapagos" },
            { "timezone.excity.Pacific/Kwajalein", "Kvad\u017ealejin" },
            { "timezone.excity.Pacific/Marquesas", "Markiz" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pago" },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatapu" },
            { "timezone.excity.Africa/Addis_Ababa", "Adis Abeba" },
            { "timezone.excity.Africa/Brazzaville", "Brazavil" },
            { "timezone.excity.Africa/Ouagadougou", "Uagadugu" },
            { "timezone.excity.America/Costa_Rica", "Kostarika" },
            { "timezone.excity.America/Grand_Turk", "Grand Turk" },
            { "timezone.excity.America/Guadeloupe", "Gvadalupe" },
            { "timezone.excity.America/Hermosillo", "Hermosiljo" },
            { "timezone.excity.America/Kralendijk", "Kralendajk" },
            { "timezone.excity.America/Louisville", "Luivile" },
            { "timezone.excity.America/Martinique", "Martinik" },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "timezone.excity.America/Montevideo", "Montevideo" },
            { "timezone.excity.America/Montserrat", "Montserat" },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "timezone.excity.America/Rio_Branco", "Rio Branko" },
            { "timezone.excity.America/St_Vincent", "Sent Vinsent" },
            { "timezone.excity.America/Whitehorse", "Vajthors" },
            { "timezone.excity.Antarctica/McMurdo", "Makmurdo" },
            { "timezone.excity.Antarctica/Rothera", "Rotera" },
            { "timezone.excity.Asia/Srednekolymsk", "Srednjekolimsk" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburg" },
            { "timezone.excity.Atlantic/Reykjavik", "Rejkjavik" },
            { "timezone.excity.Atlantic/St_Helena", "Sveta Jelena" },
            { "timezone.excity.Australia/Adelaide", "Adelejd" },
            { "timezone.excity.Australia/Brisbane", "Brizbejn" },
            { "timezone.excity.Australia/Lindeman", "Lindeman" },
            { "timezone.excity.Europe/Isle_of_Man", "Ostrvo Man" },
            { "timezone.excity.Europe/Kaliningrad", "Kalinjingrad" },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati" },
            { "timezone.excity.Africa/Johannesburg", "Johanesburg" },
            { "timezone.excity.America/El_Salvador", "Salvador" },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelson" },
            { "timezone.excity.America/Los_Angeles", "Los An\u0111eles" },
            { "timezone.excity.America/Mexico_City", "Meksiko Siti" },
            { "timezone.excity.America/Pangnirtung", "Pangnirtung" },
            { "timezone.excity.America/Porto_Velho", "Porto Veljo" },
            { "timezone.excity.America/Puerto_Rico", "Porto Riko" },
            { "timezone.excity.America/Rainy_River", "Rejni River" },
            { "timezone.excity.America/Tegucigalpa", "Tegusigalpa" },
            { "timezone.excity.America/Thunder_Bay", "Tander Bej" },
            { "timezone.excity.America/Yellowknife", "Jelounajf" },
            { "timezone.excity.Arctic/Longyearbyen", "Longjerbjen" },
            { "timezone.excity.Atlantic/Cape_Verde", "Zelenortska Ostrva" },
            { "timezone.excity.Australia/Lord_Howe", "Lord Hau" },
            { "timezone.excity.Australia/Melbourne", "Melburn" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivo" },
            { "timezone.excity.Pacific/Guadalcanal", "Gvadalkanal" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar-es-Salam" },
            { "timezone.excity.America/Blanc-Sablon", "Blank-Sejblon" },
            { "timezone.excity.America/Buenos_Aires", "Buenos Ajres" },
            { "timezone.excity.America/Campo_Grande", "Kampo Grande" },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshagen" },
            { "timezone.excity.America/Dawson_Creek", "Doson Krik" },
            { "timezone.excity.America/Indiana/Knox", "Noks, Indijana" },
            { "timezone.excity.America/Indianapolis", "Indianapolis" },
            { "timezone.excity.America/Punta_Arenas", "Punta Arenas" },
            { "timezone.excity.America/Rankin_Inlet", "Rankin Inlet" },
            { "timezone.excity.America/Santa_Isabel", "Santa Izabel" },
            { "timezone.excity.America/Scoresbysund", "Skorezbisund" },
            { "timezone.excity.Antarctica/Macquarie", "Mekvori" },
            { "timezone.excity.Pacific/Bougainville", "Buganvil" },
            { "timezone.excity.Pacific/Port_Moresby", "Port Morzbi" },
            { "timezone.excity.America/Cambridge_Bay", "Kembrid\u017e Bej" },
            { "timezone.excity.America/Ciudad_Juarez", "Siudad Huarez" },
            { "timezone.excity.America/Coral_Harbour", "Koral Harbur" },
            { "timezone.excity.America/Indiana/Vevay", "Vevaj, Indijana" },
            { "timezone.excity.America/Lower_Princes", "Louer Prinsiz Kvorter" },
            { "timezone.excity.America/Port_of_Spain", "Port of Spejn" },
            { "timezone.excity.America/Santo_Domingo", "Santo Domingo" },
            { "timezone.excity.America/St_Barthelemy", "Sv. Bartolomej" },
            { "timezone.excity.America/Swift_Current", "Svift Kurent" },
            { "timezone.excity.Australia/Broken_Hill", "Broken Hil" },
            { "timezone.excity.America/Bahia_Banderas", "Baija Banderas" },
            { "timezone.excity.America/Port-au-Prince", "Port o Prens" },
            { "timezone.excity.Atlantic/South_Georgia", "Ju\u017ena D\u017eord\u017eija" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "timezone.excity.America/Indiana/Marengo", "Marengo, Indijana" },
            { "timezone.excity.America/Indiana/Winamac", "Vinamak, Indijana" },
            { "timezone.excity.America/Argentina/Tucuman", "Tukuman" },
            { "timezone.excity.America/Argentina/Ushuaia", "U\u0161uaija" },
            { "timezone.excity.America/Indiana/Tell_City", "Tel Siti, Indijana" },
            { "timezone.excity.America/Indiana/Vincennes", "Vincenes, Indijana" },
            { "timezone.excity.Antarctica/DumontDUrville", "Dimon d\u2019Urvil" },
            { "timezone.excity.America/Argentina/La_Rioja", "La Rioha" },
            { "timezone.excity.America/Argentina/San_Juan", "San Huan" },
            { "timezone.excity.America/Argentina/San_Luis", "San Lui" },
            { "timezone.excity.America/Indiana/Petersburg", "Pitersburg, Indijana" },
            { "timezone.excity.America/Kentucky/Monticello", "Monti\u010delo, Kentaki" },
            { "timezone.excity.America/North_Dakota/Beulah", "Bijula, Severna Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Centar, Severna Dakota" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Rio Galjegos" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Novi Salem, Severna Dakota" },
        };
        return data;
    }
}
